/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskProcessLauncher;
import filenet.vw.apps.taskman.VWTaskProcessResult;
import filenet.vw.apps.taskman.VWTaskTablePanel;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.integrator.VWAdaptorNode;
import filenet.vw.apps.taskman.integrator.VWCMAdminNode;
import filenet.vw.apps.taskman.integrator.VWJavaSecurityPanel;
import filenet.vw.apps.taskman.integrator.VWManagerPropertyPanel;
import filenet.vw.apps.taskman.integrator.VWManagerTableModel;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.IVWComponentManager;
import filenet.vw.sysutils.VWJavaLauncher;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.ws.listener.utils.WSListenerProperties;
import java.awt.event.ActionEvent;
import java.io.File;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VWManagerNode
extends VWTaskBaseNode {
    protected static Logger logger = Logger.getLogger("filenet.vw.apps.taskman.integrator");
    private static final String m_className = "VWManagerNode";
    protected static final String UNDEFINED = "UNDEFINED";
    public static final String XML_NODE_NAME = "ComponentManager";
    protected static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("connectorservicemgr_32.gif");
    protected static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("connectorservicemgr_16.gif");
    protected static final ImageIcon nodeIconS32 = VWImageLoader.createImageIcon("connectorservicemgr_stop_32.gif");
    protected static final ImageIcon nodeIconS16 = VWImageLoader.createImageIcon("connectorservicemgr_stop_16.gif");
    private VWManagerPropertyPanel m_propertyPanel = null;
    private VWManagerTableModel m_tableModel = null;
    private IVWComponentManager m_manager = null;
    private int m_registryPort = 32771;
    private int m_eventPort = 32773;
    private String m_authToken = "ah0FqAXOml9OqQzIokPyegOSaNiQ";
    private String m_connectionPoint = "UNDEFINED";
    private String m_ceURI = null;
    private String[] m_libraries = null;
    private String m_jndiContext = null;
    private String m_prefJREBinPath = null;
    private String m_JREParameters = null;
    private boolean m_isService = false;
    private VWCMAdminNode m_parent = null;
    private String m_queues = "*";
    private String m_loginConfig = null;
    private String m_securityPolicy = null;
    private String m_securityManager = null;
    private String wpsFileName = null;
    private String adaptorsFilename = null;
    private static boolean wantToFixWsdl4J = true;

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 12:42:46  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.65  $";
    }

    public void delete() {
        try {
            this.m_parent.deleteCM(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.delete();
        this.cleanupListenerProperties(this.m_connectionPoint);
        this.m_propertyPanel = null;
    }

    public void refresh() {
        try {
            this.setComponentManager((IVWComponentManager)this.lookupProcess());
            if (!VWTaskCore.getInstance().isAutoMode()) {
                this.refreshAdaptorNodes();
                this.m_propertyPanel.refresh(true);
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    protected String getFullCommandLine() {
        return VWJavaLauncher.GetCmdLine(this.getJREBinPath(), this.getJavaArgs().toArray(new String[0]), this.getCommand(), false, null);
    }

    private String getCommand() {
        return "filenet.vw.integrator.base.VWComponentManager /named /routerURL " + this.m_connectionPoint + " /userName=-1 /password " + this.m_authToken + " /registryPort " + this.m_registryPort + " /eventPort " + this.m_eventPort + " /registryName " + "FileNet.VW.VWComponentManager." + this.getName() + " /queues=" + this.m_queues;
    }

    protected String getWPSFileName() {
        if (this.wpsFileName == null) {
            this.wpsFileName = new File(this.getPropertyFilePath()).getParent() + File.separator + "wps-" + this.getConnectionPoint() + ".properties";
        }
        return this.wpsFileName;
    }

    private boolean checkWPSFile() {
        return new File(this.getWPSFileName()).exists();
    }

    protected String getAdaptorsFileName() {
        if (this.adaptorsFilename == null) {
            this.adaptorsFilename = new File(this.getPropertyFilePath()).getParent() + File.separator + "adaptors-" + this.getName() + ".properties";
        }
        return this.adaptorsFilename;
    }

    private boolean checkAdaptorsFile() {
        return new File(this.getAdaptorsFileName()).exists();
    }

    private ArrayList getJavaArgs() {
        String JREParameters = this.m_JREParameters;
        ArrayList<String> javaArgs = new ArrayList<String>();
        if (this.m_ceURI != null) {
            javaArgs.add("-Dfilenet.pe.bootstrap.ceuri=" + this.m_ceURI);
        }
        try {
            if (this.checkWPSFile()) {
                javaArgs.add("-Dfilenet.wps.uid.filename=" + this.getWPSFileName());
            }
            if (this.checkAdaptorsFile()) {
                javaArgs.add("-Dfilenet.adaptors.uid.filename=" + this.getAdaptorsFileName());
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (JREParameters != null && JREParameters.length() > 0) {
            String DELIM = " -";
            int i = -1;
            int j = 0;
            do {
                if ((i = JREParameters.indexOf(" -", j)) == -1) {
                    javaArgs.add(JREParameters.substring(j));
                    continue;
                }
                String s = VWManagerNode.ridOfQuotes(JREParameters.substring(j, i).trim());
                javaArgs.add(s);
                j = i + 1;
            } while (i != -1);
        }
        javaArgs.add("-cp");
        javaArgs.add(this.getClasspath());
        if (this.m_jndiContext != null) {
            javaArgs.add("-Djava.naming.factory.initial=" + this.m_jndiContext);
        }
        if (this.m_loginConfig != null) {
            javaArgs.add("-D" + VWJavaSecurityPanel.JAVA_SECURITY_AUTH_LOGIN_CONFIG + "=" + this.m_loginConfig);
        }
        if (this.m_securityPolicy != null) {
            javaArgs.add("-D" + VWJavaSecurityPanel.JAVA_SECURITY_POLICY + "=" + this.m_securityPolicy);
        }
        if (this.m_securityManager != null) {
            javaArgs.add("-D" + VWJavaSecurityPanel.JAVA_SECURITY_MANAGER + "=" + this.m_securityManager);
        }
        if (this.noPO()) {
            javaArgs.add("-Dfilenet.PE.NOWS=true");
        } else {
            javaArgs.add("-Dorg.apache.axis.components.net.SecureSocketFactory=filenet.ws.utils.jsse.FnJSSESocketFactory");
        }
        return javaArgs;
    }

    public void start() throws Exception {
        try {
            this.refresh();
            if (this.isStarted()) {
                return;
            }
            this.writeMessage(Level.INFO, VWResource.StartingComponentManager);
            String command = this.getCommand();
            ArrayList javaArgs = this.getJavaArgs();
            VWTaskProcessResult result = VWTaskProcessLauncher.launchJavaServer(javaArgs, command, true, null, this);
            if (result.getResult() == null) {
                throw new Exception(result.getError());
            }
            this.setComponentManager((IVWComponentManager)result.getResult());
            this.writeMessage(Level.INFO, VWResource.ComponentManagerStarted);
            this.refreshAdaptorNodes();
            this.getTaskCore().expandNode(this, false);
        }
        catch (Exception ex) {
            this.m_manager = null;
            throw ex;
        }
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel.refresh(false);
        }
    }

    public void stop() throws Exception {
        this.refresh();
        if (!this.isStarted()) {
            return;
        }
        try {
            this.writeMessage(Level.INFO, VWResource.StoppingComponentManager);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.setConsoleHandler(null);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            VWDebug.logInfo("Stopping component manager, calling IVWComponentManager.stop()...");
            this.m_manager.stop();
        }
        catch (UnmarshalException ex) {
            // empty catch block
        }
        VWDebug.logInfo("Component manager has been stopped.");
        this.m_manager = null;
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel.refresh(false);
            try {
                this.refreshAdaptorNodes();
            }
            catch (Exception e) {
                this.displayError(e);
            }
        }
        try {
            this.writeMessage(Level.INFO, VWResource.ComponentManagerStopped);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isStarted() {
        return this.m_manager != null;
    }

    public Icon getIcon16() {
        if (this.isStarted()) {
            return nodeIcon16;
        }
        return nodeIconS16;
    }

    public Icon getIcon32() {
        if (this.isStarted()) {
            return nodeIcon32;
        }
        return nodeIconS32;
    }

    public String toString() {
        return this.getName();
    }

    public void displayHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_TaskManager + "cm.htm");
    }

    public Object lookupProcess() throws Exception {
        IVWComponentManager cm = null;
        Exception ex = null;
        try {
            String url = "rmi://localhost:" + Integer.toString(this.m_registryPort) + "/FileNet.VW.VWComponentManager." + this.getName();
            cm = (IVWComponentManager)Naming.lookup(url);
            cm.getAdaptorNames();
        }
        catch (NotBoundException e) {
            ex = e;
        }
        catch (RemoteException e) {
            ex = e;
        }
        if (ex != null) {
            VWDebug.logInfo("VWManagerNode::lookupProcess() - " + ex.getLocalizedMessage());
            cm = null;
        }
        return cm;
    }

    public String getJREBinPath() {
        String binPath = this.getPreferredJREBinPath();
        if (binPath != null) {
            return binPath;
        }
        return super.getJREBinPath();
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.START) == 0) {
                this.start();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.STOP) == 0) {
                this.stop();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.REFRESH_COMPONENT_CONFIGS) == 0) {
                this.m_manager.refreshAllAdaptors();
                this.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.REFRESH) == 0) {
                this.refresh();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.DELETE) == 0) {
                this.delete();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.displayHelp();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public String[] getActions() {
        String[] actions = new String[]{VWTaskActionCommand.START, VWTaskActionCommand.STOP, VWTaskActionCommand.REFRESH_COMPONENT_CONFIGS, VWTaskActionCommand.DELETE, "Add Separator", VWTaskActionCommand.HELP};
        return actions;
    }

    public boolean isActionEnabled(String actionCMD) {
        if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.START) == 0) {
            return this.showStartIcon();
        }
        if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.STOP) == 0) {
            return this.showStopIcon();
        }
        if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.REFRESH_COMPONENT_CONFIGS) == 0) {
            return this.showStopIcon();
        }
        if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.DELETE) == 0) {
            return this.showStartIcon();
        }
        return true;
    }

    public boolean showStartIcon() {
        return !this.isStarted();
    }

    public boolean showStopIcon() {
        return this.isStarted() && (this.m_isService ? this.getBooleanProperty("TaskManager.ComponentManager.CustomService.Administer") : !this.m_isService);
    }

    public boolean showDeleteIcon() {
        return !this.isStarted();
    }

    public boolean showPropertyIcon() {
        return true;
    }

    public boolean showCommitIcon() {
        return false;
    }

    public boolean showDiscardIcon() {
        return false;
    }

    public void toXML(StringBuffer theBuffer) {
        String ATTRIB_INDENT = "\t\t\t";
        theBuffer.append("\t\t<ComponentManager\n");
        theBuffer.append(ATTRIB_INDENT + this.getAutoStartAttributeString() + "\n");
        theBuffer.append(ATTRIB_INDENT + "RouterURL=\"" + VWTaskXMLHandler.toXMLString(this.getConnectionPoint()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "CEURI=\"" + VWTaskXMLHandler.toXMLString(this.m_ceURI) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Options=\"" + VWTaskXMLHandler.toXMLString(this.getOptions()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Port=\"" + this.getRegistryPort() + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "EventPort=\"" + this.getEventPort() + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Queues=\"" + this.getQueues() + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Upgraded=\"1\"\n");
        theBuffer.append(ATTRIB_INDENT + "JNDIInitialContextFactory=\"" + VWTaskXMLHandler.toXMLString(this.getJNDIContext()) + "\"\n");
        if (this.m_prefJREBinPath != null) {
            theBuffer.append(ATTRIB_INDENT + "JREBinPath=\"" + this.m_prefJREBinPath + "\"\n");
        }
        theBuffer.append(ATTRIB_INDENT + "JREParameters=\"" + VWTaskXMLHandler.toXMLString(this.getJREParameters()) + "\"\n");
        if (this.m_loginConfig != null) {
            theBuffer.append(ATTRIB_INDENT).append(VWJavaSecurityPanel.JAVA_SECURITY_AUTH_LOGIN_CONFIG).append("=\"").append(VWTaskXMLHandler.toXMLString(this.getLoginConfig())).append("\"\n");
        }
        if (this.m_securityPolicy != null) {
            theBuffer.append(ATTRIB_INDENT).append(VWJavaSecurityPanel.JAVA_SECURITY_POLICY).append("=\"").append(VWTaskXMLHandler.toXMLString(this.getSecurityPolicy())).append("\"\n");
        }
        if (this.m_securityManager != null) {
            theBuffer.append(ATTRIB_INDENT).append(VWJavaSecurityPanel.JAVA_SECURITY_MANAGER).append("=\"").append(VWTaskXMLHandler.toXMLString(this.getSecurityManager())).append("\"\n");
        }
        theBuffer.append(ATTRIB_INDENT).append("RequiredLibraries=\"");
        if (this.m_libraries != null) {
            this.fixWsdl4J();
            for (int i = 0; i < this.m_libraries.length; ++i) {
                if (i > 0) {
                    theBuffer.append(File.pathSeparator);
                }
                theBuffer.append(VWTaskXMLHandler.toXMLString(this.m_libraries[i]));
            }
        }
        theBuffer.append("\"\n");
        theBuffer.append("\t\t/>\n");
    }

    protected VWManagerNode(Node cmXMLNode, String propertiesPath, VWCMAdminNode parent, String cpName, String options) throws Exception {
        super("", propertiesPath, "TaskManager.ComponentManager", 18);
        this.m_parent = parent;
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
        this.setExpandAtStartup(true);
        this.getSystemProperties();
        this.getFullLibraries();
        if (cmXMLNode != null) {
            this.fromXML(cmXMLNode);
        } else {
            this.setConnectionPoint(cpName);
            this.setAutoStartEnabled(true);
        }
        if (this.m_ceURI == null) {
            this.m_ceURI = parent.getCEURI();
        }
        if (this.m_JREParameters == null) {
            this.m_JREParameters = this.getDefaultJVMParameters();
        }
        if (options != null) {
            this.setOptions(options);
        }
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel = new VWManagerPropertyPanel(this);
            this.getContentPane().setPropertyPanel(this.m_propertyPanel, true, true);
            this.m_tableModel = new VWManagerTableModel(this);
            this.getContentPane().setTablePanel(new VWTaskTablePanel(this.m_tableModel));
        }
    }

    protected int getRegistryPort() {
        return this.m_registryPort;
    }

    protected void setRegistryPort(int registryPort) {
        this.m_registryPort = registryPort;
    }

    protected int getEventPort() {
        return this.m_eventPort;
    }

    protected void setEventPort(int eventPort) {
        this.m_eventPort = eventPort;
    }

    protected String getQueues() {
        return this.m_queues;
    }

    protected void setQueues(String q) {
        this.m_queues = q;
        this.setName(VWManagerNode.FormNodeName(this.m_connectionPoint, this.m_queues));
        this.adaptorsFilename = null;
    }

    protected String getConnectionPoint() {
        return this.m_connectionPoint;
    }

    protected void setConnectionPoint(String cp) {
        String oldCP = this.m_connectionPoint;
        this.m_connectionPoint = cp != null ? cp.trim() : UNDEFINED;
        this.setName(VWManagerNode.FormNodeName(this.m_connectionPoint, this.m_queues));
        if (oldCP != null) {
            this.fixupListenerProperties(oldCP, this.m_connectionPoint);
        }
    }

    protected String getCEURI() {
        return this.m_ceURI;
    }

    protected void setCEURI(String s) {
        this.m_ceURI = s == null || s.trim().length() == 0 ? VWCMAdminNode.GetDefaultCEURI() : s;
    }

    protected void cleanupListenerProperties(String cp) {
        WSListenerProperties m_listenerProps = this.getWSListenerProperties();
        if (m_listenerProps != null) {
            m_listenerProps.cleanupStanza(cp);
        }
    }

    protected void fixupListenerProperties(String oldCp, String newCp) {
        WSListenerProperties m_listenerProps = this.getWSListenerProperties();
        if (m_listenerProps != null) {
            m_listenerProps.renameStanza(oldCp, newCp);
        }
    }

    protected String getOptions() {
        return this.m_authToken;
    }

    protected void setOptions(String options) {
        this.m_authToken = options;
    }

    protected String[] getLibraries() {
        return this.m_libraries;
    }

    protected void setLibraries(String[] libraries) {
        this.m_libraries = libraries;
    }

    protected String getJNDIContext() {
        return this.m_jndiContext;
    }

    protected String getPreferredJREBinPath() {
        return this.m_prefJREBinPath;
    }

    protected String getJREParameters() {
        return this.m_JREParameters;
    }

    protected String getLoginConfig() {
        return this.m_loginConfig;
    }

    protected String getSecurityManager() {
        return this.m_securityManager;
    }

    protected String getSecurityPolicy() {
        return this.m_securityPolicy;
    }

    protected void setJNDIContext(String context) {
        this.m_jndiContext = context == null ? null : (context.trim().equals("") ? null : context);
    }

    protected void setPreferredJREBinPath(String jreBinPath) {
        this.m_prefJREBinPath = jreBinPath == null ? null : (jreBinPath.trim().equals("") ? null : jreBinPath);
    }

    protected void setJREParameters(String jreParameters) {
        this.m_JREParameters = jreParameters == null ? null : (jreParameters.trim().equals("") ? null : jreParameters);
        if (this.m_JREParameters != null && this.m_JREParameters.indexOf(10) >= 0) {
            this.m_JREParameters = this.m_JREParameters.replace('\n', ' ');
        }
    }

    protected void setLoginConfig(String s) {
        this.m_loginConfig = s == null ? null : (s.trim().equals("") ? null : s);
    }

    protected void setSecurityPolicy(String s) {
        this.m_securityPolicy = s == null ? null : (s.trim().equals("") ? null : s);
    }

    protected void setSecurityManager(String s) {
        this.m_securityManager = s == null ? null : (s.trim().equals("") ? null : s);
    }

    private void setComponentManager(IVWComponentManager cm) throws Exception {
        try {
            this.m_manager = cm;
            if (cm != null) {
                this.m_isService = cm.isCustomService();
                try {
                    this.setConsoleHandler(cm.getConsoleHandler());
                }
                catch (Exception e) {
                    VWDebug.logException(e, "Error while setting the console handler for Component Manager.");
                }
            } else {
                this.setConsoleHandler(null);
            }
        }
        catch (Exception e) {
            this.m_manager = null;
            throw e;
        }
    }

    private void refreshAdaptorNodes() throws Exception {
        if (VWTaskCore.getInstance().isAutoMode()) {
            return;
        }
        if (this.m_manager != null) {
            Hashtable<String, String> adaptorTable = new Hashtable<String, String>();
            String[] names = this.m_manager.getAdaptorNames();
            for (int i = 0; i < names.length; ++i) {
                adaptorTable.put(names[i], "");
                VWAdaptorNode adaptorNode = (VWAdaptorNode)this.findChildNode(19, names[i]);
                if (adaptorNode != null) {
                    adaptorNode.setAdaptor(this.m_manager.getAdaptorControl(names[i]));
                    continue;
                }
                this.add(new VWAdaptorNode(this.m_manager.getAdaptorControl(names[i])), 1);
            }
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                VWAdaptorNode aNode = (VWAdaptorNode)e.nextElement();
                if (adaptorTable.containsKey(aNode.getName())) continue;
                aNode.delete();
            }
            this.m_tableModel.refresh();
        } else {
            this.removeAllChildren();
        }
    }

    private void fromXML(Node node) throws VWException {
        if (node == null || node.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)node;
        try {
            boolean needToUpgrade;
            this.setAutoStartEnabled(ele);
            boolean bl = needToUpgrade = ele.getAttributeNode("Upgraded") == null;
            if (ele.getAttributeNode("Queues") != null) {
                this.setQueues(ele.getAttribute("Queues"));
            }
            if (ele.getAttributeNode("Port") != null) {
                this.setRegistryPort(Integer.parseInt(ele.getAttribute("Port")));
            }
            if (ele.getAttributeNode("EventPort") != null) {
                this.setEventPort(Integer.parseInt(ele.getAttribute("EventPort")));
            }
            if (ele.getAttributeNode("RouterURL") != null) {
                String connectionPoint = ele.getAttribute("RouterURL");
                int index = connectionPoint.lastIndexOf("/");
                if (index != -1 && connectionPoint.length() > index + 1) {
                    connectionPoint = connectionPoint.substring(index + 1);
                }
                this.setConnectionPoint(connectionPoint);
            } else {
                this.setConnectionPoint(UNDEFINED);
            }
            if (ele.getAttributeNode("Options") != null) {
                this.setOptions(ele.getAttribute("Options"));
            }
            if (ele.getAttributeNode("JNDIInitialContextFactory") != null) {
                this.setJNDIContext(ele.getAttribute("JNDIInitialContextFactory"));
            }
            if (ele.getAttributeNode("JREBinPath") != null) {
                this.m_prefJREBinPath = ele.getAttribute("JREBinPath");
            }
            if (ele.getAttributeNode(VWJavaSecurityPanel.JAVA_SECURITY_AUTH_LOGIN_CONFIG) != null) {
                this.setLoginConfig(ele.getAttribute(VWJavaSecurityPanel.JAVA_SECURITY_AUTH_LOGIN_CONFIG));
            }
            if (ele.getAttributeNode(VWJavaSecurityPanel.JAVA_SECURITY_POLICY) != null) {
                this.setSecurityPolicy(ele.getAttribute(VWJavaSecurityPanel.JAVA_SECURITY_POLICY));
            }
            if (ele.getAttributeNode(VWJavaSecurityPanel.JAVA_SECURITY_MANAGER) != null) {
                this.setSecurityManager(ele.getAttribute(VWJavaSecurityPanel.JAVA_SECURITY_MANAGER));
            }
            if (ele.getAttributeNode("RequiredLibraries") != null) {
                this.m_libraries = ele.getAttribute("RequiredLibraries").split(File.pathSeparator);
            }
            if (needToUpgrade) {
                this.getFullLibraries();
            }
            String defaultJREParams = this.getDefaultJVMParameters();
            if (ele.getAttributeNode("JREParameters") != null) {
                String curJREParams = ele.getAttribute("JREParameters");
                if (needToUpgrade) {
                    curJREParams = defaultJREParams + " " + curJREParams;
                }
                this.setJREParameters(curJREParams);
            } else {
                this.setJREParameters(defaultJREParams);
            }
            if (ele.getAttributeNode("CEURI") != null) {
                this.setCEURI(ele.getAttribute("CEURI"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getSystemProperties() {
        this.m_loginConfig = System.getProperty(VWJavaSecurityPanel.JAVA_SECURITY_AUTH_LOGIN_CONFIG);
        this.m_securityPolicy = System.getProperty(VWJavaSecurityPanel.JAVA_SECURITY_POLICY);
        this.m_securityManager = System.getProperty(VWJavaSecurityPanel.JAVA_SECURITY_MANAGER);
    }

    private static String ridOfQuotes(String s) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    private void getFullLibraries() {
        StringBuffer cp = new StringBuffer();
        String cmClassPath = this.getProperty("TaskManager.ComponentManager.ClassPath", System.getProperty("java.class.path"));
        if (cmClassPath != null) {
            cp.append(cmClassPath);
        }
        if (this.m_libraries != null) {
            int nLibraries = this.m_libraries.length;
            for (int i = 0; i < nLibraries; ++i) {
                cp.append(File.pathSeparator).append(this.m_libraries[i]);
            }
        }
        String S = this.getCleanClasspath(cp.toString());
        this.m_libraries = S.split(File.pathSeparator);
        this.fixWsdl4J();
    }

    private void fixWsdl4J() {
        if (!wantToFixWsdl4J) {
            return;
        }
        String m_method = "fixWsdl4J";
        int nLibraries = this.m_libraries == null ? 0 : this.m_libraries.length;
        int waspJarIndex = -1;
        int wsdl4jJarIndex = -1;
        for (int i = 0; i < nLibraries; ++i) {
            if (this.m_libraries[i].indexOf("wasp.jar") != -1) {
                if (wsdl4jJarIndex >= 0) {
                    return;
                }
                waspJarIndex = i;
                continue;
            }
            if (this.m_libraries[i].indexOf("wsdl4j.jar") == -1) continue;
            if (waspJarIndex < 0) {
                return;
            }
            wsdl4jJarIndex = i;
            break;
        }
        logger.finest(m_className, "fixWsdl4J", "Found index = " + waspJarIndex + ", " + wsdl4jJarIndex);
        if (waspJarIndex < 0 || wsdl4jJarIndex < 0 || waspJarIndex > wsdl4jJarIndex) {
            return;
        }
        String wsdl4JarPath = this.m_libraries[wsdl4jJarIndex];
        for (int i = wsdl4jJarIndex; i > waspJarIndex; --i) {
            this.m_libraries[i] = this.m_libraries[i - 1];
        }
        this.m_libraries[waspJarIndex] = wsdl4JarPath;
    }

    private String getClasspathFromLibraries() {
        StringBuffer cp = new StringBuffer();
        if (this.m_libraries != null) {
            this.fixWsdl4J();
            for (int i = 0; i < this.m_libraries.length; ++i) {
                cp.append(File.pathSeparator).append(this.m_libraries[i]);
            }
        }
        return cp.toString();
    }

    private String getClasspath() {
        String res = this.getCleanClasspath(this.getClasspathFromLibraries());
        if (res == null || res.trim().length() == 0) {
            res = this.getCleanClasspath(this.getProperty("TaskManager.ComponentManager.ClassPath", System.getProperty("java.class.path")));
            this.m_libraries = res.split(File.pathSeparator);
            res = this.getClasspathFromLibraries();
        }
        return res;
    }

    private String getCleanClasspath(String s) {
        String m_method = "getCleanClasspath";
        String[] ss = s.split(File.pathSeparator);
        int nSS = ss == null ? 0 : ss.length;
        Vector<String> v = new Vector<String>(nSS);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < nSS; ++i) {
            File f;
            if (ss[i].trim().length() <= 0 || !(f = new File(ss[i].trim())).exists()) continue;
            try {
                String fullPath = f.getCanonicalPath();
                if (v.contains(fullPath)) continue;
                v.add(fullPath);
                buf.append(fullPath);
                buf.append(File.pathSeparatorChar);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        s = buf.toString();
        if (logger.isFinest()) {
            logger.finest(m_className, "getCleanClasspath", s);
        }
        return s;
    }

    private String getDefaultJVMParameters() {
        return this.getProperty("TaskManager.ComponentManager.CEAPI.JVMOpts", null);
    }

    protected static String FormNodeName(String connectionPoint, String queues) {
        if (queues.equals("*")) {
            return connectionPoint + ".ALL";
        }
        return connectionPoint + "." + queues.replace(',', '.');
    }

    protected WSListenerProperties getWSListenerProperties() {
        WSListenerProperties props = this.m_parent.getListenerProperties(this.getConnectionPoint());
        if (props != null) {
            props.setStanza(this.getConnectionPoint());
        }
        return props;
    }

    private boolean noPO() {
        if (this.getWSListenerProperties() == null) {
            return true;
        }
        return !this.m_queues.equals("*") && this.m_queues.indexOf("WSRequest") < 0;
    }

    static {
        wantToFixWsdl4J = System.getProperty("filenet.ae.taskman.cm.no.wsdl4j.fix") == null;
    }
}

